import moment from 'moment'
import { Chart, registerables } from 'chart.js'
import { GoogleCharts } from 'google-charts'

import { fill_missing_dates } from './common'

const default_chart_config = {
    chartArea: {
        left: "10%",
        top: "10%",
        width: "85%",
        height: "85%"
    },
    colors: [
        "#4CAF50",
        "#8BC34A",
        "#FFC107",
        "#FF9800",
        "#FF5722",
        "#E91E63",
        "#9C27B0",
        "#673AB7"
    ]
}

if (typeof DASHBOARD != 'undefined' && !!Object.keys(DASHBOARD).length)
{

    let { clicks_over_time, top_devices, top_browsers, top_os, top_locations } = DASHBOARD

    window.addEventListener("resize", function (event) {

        draw_top_locations()
        draw_top_devices()
        draw_top_browsers()
        draw_top_os()
    });


    //======================== Clicks Over Time Chart =========================

    // importing charts & registering all its plugins.
    Chart.register(...registerables)

    // Settings Charts
    let labels = clicks_over_time.dates
    let data = clicks_over_time.clicks

    // Filling missing days & re-formating.
    fill_missing_dates(labels, data, 'YYYY-MM-DD')
    labels = labels.map(day => moment(day, 'YYYY-MM-DD').format('MMM D'))

    const ctx = document.getElementById('clicks-over-time').getContext('2d')

    const myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: labels,
            datasets: [{
                label: 'Clicks',
                data: data,
                lineTension: 0.2,
                backgroundColor: [
                    'rgba(54, 162, 235, 0.2)',
                    'rgba(140, 193, 82, 0.2)',
                    'rgba(54, 162, 235, 0.2)',
                    'rgba(255, 206, 86, 0.2)',
                    'rgba(75, 192, 192, 0.2)',
                    'rgba(153, 102, 255, 0.2)', // purpal
                    'rgba(255, 159, 64, 0.2)'
                ],
                borderColor: [
                    'rgba(54, 162, 235, 1)'
                ],
                borderWidth: 2
            }]
        },
        options: {
            responsive: true,
            scales: {
                y: {
                    beginAtZero: true
                }
            },
        }
    });

    //======================== Top locations (Google map) =========================

    GoogleCharts.load(draw_top_locations, {
        'packages': ['geochart'],
    });

    function draw_top_locations() {
        let data = GoogleCharts.api.visualization.arrayToDataTable([
            ['Country', 'Clicks'],
            ...top_locations
        ]);

        let options = {
            legend: {
                position: 'bottom',
                textStyle: {
                    color: 'black',
                    fontSize: 13,
                    fontName: 'EncodeSans'
                }
            },
            bar: { groupWidth: '25%' },
            colors: ['#ccb8fc', '#6C55A3'],
            isStacked: true,
            chartArea: { left: 0, top: 0, width: '100%', height: '80%' },
            axisTitlesPosition: 'none',
            hAxis: { textPosition: 'none', gridlines: { color: 'transparent' }, baselineColor: 'transparent' },
            vAxis: { textPosition: 'none', gridlines: { color: 'transparent' }, baselineColor: 'transparent' },
        };

        let chart = new GoogleCharts.api.visualization.GeoChart(document.getElementById('top-locations'));

        chart.draw(data, options);
    }

    //======================== Top Devices =========================

    GoogleCharts.load(draw_top_devices, {
        'packages': ['corechart']
    });

    GoogleCharts.load(draw_top_browsers, {
        'packages': ['corechart']
    });

    GoogleCharts.load(draw_top_os, {
        'packages': ['corechart']
    });

    function draw_top_devices() {

        let data = GoogleCharts.api.visualization.arrayToDataTable([
            ['Device', 'Clicks'],
            ...top_devices
        ]);

        let options = {
            ...default_chart_config
        };

        let chart = new GoogleCharts.api.visualization.PieChart(document.getElementById('top-devices'));

        chart.draw(data, options);
    }

    function draw_top_browsers() {

        let data = GoogleCharts.api.visualization.arrayToDataTable([
            ['Browser', 'Clicks'],
            ...top_browsers
        ]);

        let options = {
            ...default_chart_config
        };

        let chart = new GoogleCharts.api.visualization.PieChart(document.getElementById('top-browsers'));

        chart.draw(data, options);
    }

    function draw_top_os() {

        let data = GoogleCharts.api.visualization.arrayToDataTable([
            ['OS', 'Clicks'],
            ...top_os
        ]);

        let options = {
            ...default_chart_config
        };

        let chart = new GoogleCharts.api.visualization.PieChart(document.getElementById('top-os'));

        chart.draw(data, options);
    }
} // End of DASHBOARD
